/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.network.pipe.attachment.extractor;

import com.refinedmods.refinedpipes.network.item.ItemNetwork;
import com.refinedmods.refinedpipes.network.pipe.Destination;
import com.refinedmods.refinedpipes.network.pipe.DestinationType;
import com.refinedmods.refinedpipes.network.pipe.attachment.Attachment;
import com.refinedmods.refinedpipes.network.pipe.attachment.extractor.RoutingMode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemDestinationFinder {
    private final Attachment attachment;
    private int roundRobinIndex;

    public ItemDestinationFinder(Attachment attachment) {
        this.attachment = attachment;
    }

    public Destination find(RoutingMode routingMode, BlockPos sourcePos, ItemStack extracted) {
        ItemNetwork network = (ItemNetwork)this.attachment.getPipe().getNetwork();
        switch (routingMode) {
            case NEAREST: {
                return network.getDestinationPathCache().findNearestDestination(this.attachment.getPipe().getPos(), d -> this.isDestinationApplicable(sourcePos, extracted, (Destination)d));
            }
            case FURTHEST: {
                return network.getDestinationPathCache().findFurthestDestination(this.attachment.getPipe().getPos(), d -> this.isDestinationApplicable(sourcePos, extracted, (Destination)d));
            }
            case RANDOM: {
                ArrayList<Destination> destinations = new ArrayList<Destination>(network.getDestinations(DestinationType.ITEM_HANDLER));
                while (!destinations.isEmpty()) {
                    int randomIndex = this.attachment.getPipe().getLevel().m_5822_().nextInt(destinations.size());
                    Destination randomDestination = (Destination)destinations.get(randomIndex);
                    if (this.isDestinationApplicable(sourcePos, extracted, randomDestination)) {
                        return randomDestination;
                    }
                    destinations.remove(randomIndex);
                }
                return null;
            }
            case ROUND_ROBIN: {
                List<Destination> destinations = network.getDestinations(DestinationType.ITEM_HANDLER);
                if (destinations.isEmpty()) {
                    return null;
                }
                if (this.roundRobinIndex >= destinations.size()) {
                    this.roundRobinIndex = 0;
                }
                do {
                    Destination dest;
                    if (this.isDestinationApplicable(sourcePos, extracted, dest = destinations.get(this.roundRobinIndex))) {
                        ++this.roundRobinIndex;
                        return dest;
                    }
                    ++this.roundRobinIndex;
                } while (this.roundRobinIndex < destinations.size());
                return null;
            }
        }
        throw new RuntimeException("?");
    }

    private boolean isDestinationApplicable(BlockPos sourcePos, ItemStack extracted, Destination destination) {
        BlockEntity blockEntity = destination.getConnectedPipe().getLevel().m_7702_(destination.getReceiver());
        if (blockEntity == null) {
            return false;
        }
        IItemHandler handler = (IItemHandler)blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, destination.getIncomingDirection().m_122424_()).orElse(null);
        if (handler == null) {
            return false;
        }
        if (destination.getReceiver().equals((Object)sourcePos) && destination.getIncomingDirection() == this.attachment.getDirection()) {
            return false;
        }
        return ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)extracted, (boolean)true).m_41619_();
    }

    public int getRoundRobinIndex() {
        return this.roundRobinIndex;
    }

    public void setRoundRobinIndex(int roundRobinIndex) {
        this.roundRobinIndex = roundRobinIndex;
    }
}

